/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    protected static final int f_154980_ = 0;
    protected static final int f_154981_ = 1;
    protected static final int f_154982_ = 2;
    public static final int f_154983_ = 0;
    private static final int[] f_58313_ = new int[]{0};
    private static final int[] f_58314_ = new int[]{2, 1};
    private static final int[] f_58315_ = new int[]{1};
    public static final int f_154984_ = 1;
    public static final int f_154985_ = 2;
    public static final int f_154986_ = 3;
    public static final int f_154987_ = 4;
    public static final int f_154988_ = 200;
    public static final int f_154989_ = 2;
    protected NonNullList<net.minecraft.world.item.ItemStack> f_58310_ = NonNullList.m_122780_((int)3, (Object)((Object)net.minecraft.world.item.ItemStack.f_41583_));
    public int f_58316_;
    int f_58317_;
    public int f_58318_;
    public int f_58319_;
    protected final ContainerData f_58311_ = new ContainerData(){

        public int m_6413_(int p_58431_) {
            switch (p_58431_) {
                case 0: {
                    return AbstractFurnaceBlockEntity.this.f_58316_;
                }
                case 1: {
                    return AbstractFurnaceBlockEntity.this.f_58317_;
                }
                case 2: {
                    return AbstractFurnaceBlockEntity.this.f_58318_;
                }
                case 3: {
                    return AbstractFurnaceBlockEntity.this.f_58319_;
                }
            }
            return 0;
        }

        public void m_8050_(int p_58433_, int p_58434_) {
            switch (p_58433_) {
                case 0: {
                    AbstractFurnaceBlockEntity.this.f_58316_ = p_58434_;
                    break;
                }
                case 1: {
                    AbstractFurnaceBlockEntity.this.f_58317_ = p_58434_;
                    break;
                }
                case 2: {
                    AbstractFurnaceBlockEntity.this.f_58318_ = p_58434_;
                    break;
                }
                case 3: {
                    AbstractFurnaceBlockEntity.this.f_58319_ = p_58434_;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> f_58320_ = new Object2IntOpenHashMap();
    private final RecipeType<? extends AbstractCookingRecipe> f_58312_;
    @Nullable
    private Level burn_level;
    @Nullable
    private BlockPos burn_pos;
    private static BlockPos createExperience_blockposition;
    private static Player createExperience_entityhuman;
    private static net.minecraft.world.item.ItemStack createExperience_itemstack;
    private static int createExperience_amount;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private int maxStack = 64;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    protected AbstractFurnaceBlockEntity(BlockEntityType<?> p_154991_, BlockPos p_154992_, BlockState p_154993_, RecipeType<? extends AbstractCookingRecipe> p_154994_) {
        super(p_154991_, p_154992_, p_154993_);
        this.f_58312_ = p_154994_;
    }

    @Deprecated
    public static Map<Item, Integer> m_58423_() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42448_, 20000);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50353_, 16000);
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42585_, 2400);
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42413_, 1600);
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42414_, 1600);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13182_, 300);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13168_, 300);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13174_, 300);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13175_, 150);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13178_, 300);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13177_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50132_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50480_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50479_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50481_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50483_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50482_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50192_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50475_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50474_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50476_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50478_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50477_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50065_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50078_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50624_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50131_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50087_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50325_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50091_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50329_, 300);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13191_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42411_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42523_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50155_, 300);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13157_, 200);
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42421_, 200);
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42420_, 200);
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42424_, 200);
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42423_, 200);
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42422_, 200);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13173_, 200);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13155_, 1200);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13167_, 100);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13170_, 100);
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42398_, 100);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13180_, 100);
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42399_, 100);
        AbstractFurnaceBlockEntity.m_204302_(map, ItemTags.f_13172_, 67);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50577_, 4001);
        AbstractFurnaceBlockEntity.m_58374_(map, Items.f_42717_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50571_, 50);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50036_, 100);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50616_, 400);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50617_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50618_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50621_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50622_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50625_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_50715_, 300);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_152541_, 100);
        AbstractFurnaceBlockEntity.m_58374_(map, Blocks.f_152542_, 100);
        return map;
    }

    private static boolean m_58397_(Item p_58398_) {
        return p_58398_.m_204114_().m_203656_(ItemTags.f_13153_);
    }

    private static void m_204302_(Map<Item, Integer> p_204303_, TagKey<Item> p_204304_, int p_204305_) {
        for (Holder holder : Registry.f_122827_.m_206058_(p_204304_)) {
            if (AbstractFurnaceBlockEntity.m_58397_((Item)((Object)holder.m_203334_()))) continue;
            p_204303_.put((Item)((Object)holder.m_203334_()), p_204305_);
        }
    }

    private static void m_58374_(Map<Item, Integer> p_58375_, ItemLike p_58376_, int p_58377_) {
        Item item = p_58376_.m_5456_();
        if (AbstractFurnaceBlockEntity.m_58397_(item)) {
            if (SharedConstants.f_136183_) {
                throw Util.m_137570_(new IllegalStateException("A developer tried to explicitly make fire resistant item " + item.m_7626_(null).getString() + " a furnace fuel. That will not work!"));
            }
        } else {
            p_58375_.put(item, p_58377_);
        }
    }

    private boolean m_58425_() {
        return this.f_58316_ > 0;
    }

    @Override
    public void m_142466_(CompoundTag p_155025_) {
        super.m_142466_(p_155025_);
        this.f_58310_ = NonNullList.m_122780_((int)this.m_6643_(), (Object)((Object)net.minecraft.world.item.ItemStack.f_41583_));
        ContainerHelper.m_18980_((CompoundTag)p_155025_, this.f_58310_);
        this.f_58316_ = p_155025_.m_128451_("BurnTime");
        this.f_58318_ = p_155025_.m_128451_("CookTime");
        this.f_58319_ = p_155025_.m_128451_("CookTimeTotal");
        this.f_58317_ = this.m_7743_((net.minecraft.world.item.ItemStack)((Object)this.f_58310_.get(1)));
        CompoundTag compoundtag = p_155025_.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.f_58320_.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    @Override
    protected void m_183515_(CompoundTag p_187452_) {
        super.m_183515_(p_187452_);
        p_187452_.m_128405_("BurnTime", this.f_58316_);
        p_187452_.m_128405_("CookTime", this.f_58318_);
        p_187452_.m_128405_("CookTimeTotal", this.f_58319_);
        ContainerHelper.m_18973_((CompoundTag)p_187452_, this.f_58310_);
        CompoundTag compoundtag = new CompoundTag();
        this.f_58320_.forEach((p_187449_, p_187450_) -> compoundtag.m_128405_(p_187449_.toString(), (int)p_187450_));
        p_187452_.m_128365_("RecipesUsed", compoundtag);
    }

    public static void m_155013_(Level p_155014_, BlockPos p_155015_, BlockState p_155016_, AbstractFurnaceBlockEntity p_155017_) {
        boolean flag = p_155017_.m_58425_();
        boolean flag1 = false;
        if (p_155017_.m_58425_()) {
            --p_155017_.f_58316_;
        }
        net.minecraft.world.item.ItemStack itemstack = (net.minecraft.world.item.ItemStack)((Object)p_155017_.f_58310_.get(1));
        if (p_155017_.m_58425_() || !itemstack.m_41619_() && !((net.minecraft.world.item.ItemStack)((Object)p_155017_.f_58310_.get(0))).m_41619_()) {
            Recipe recipe = p_155014_.m_7465_().m_44015_(p_155017_.f_58312_, p_155017_, p_155014_).orElse(null);
            int i = p_155017_.m_6893_();
            if (!p_155017_.m_58425_() && p_155017_.m_155005_(recipe, p_155017_.f_58310_, i)) {
                CraftItemStack fuel = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack);
                FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent((Block)CraftBlock.at((LevelAccessor)p_155014_, (BlockPos)p_155015_), (ItemStack)fuel, p_155017_.m_7743_(itemstack));
                p_155014_.getCraftServer().getPluginManager().callEvent((Event)furnaceBurnEvent);
                if (furnaceBurnEvent.isCancelled()) {
                    return;
                }
                p_155017_.f_58317_ = p_155017_.f_58316_ = furnaceBurnEvent.getBurnTime();
                if (p_155017_.m_58425_() && furnaceBurnEvent.isBurning()) {
                    flag1 = true;
                    if (itemstack.hasContainerItem()) {
                        p_155017_.f_58310_.set(1, (Object)itemstack.getContainerItem());
                    } else if (!itemstack.m_41619_()) {
                        Item item = itemstack.m_41720_();
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            p_155017_.f_58310_.set(1, (Object)itemstack.getContainerItem());
                        }
                    }
                }
            }
            if (p_155017_.m_58425_() && p_155017_.m_155005_(recipe, p_155017_.f_58310_, i)) {
                if (recipe != null && p_155017_.f_58318_ == 0) {
                    CraftItemStack source = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)((Object)p_155017_.f_58310_.get(0))));
                    CookingRecipe cookingRecipe = (CookingRecipe)recipe.toBukkitRecipe();
                    FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent((Block)CraftBlock.at((LevelAccessor)p_155014_, (BlockPos)p_155015_), (ItemStack)source, cookingRecipe);
                    p_155014_.getCraftServer().getPluginManager().callEvent((Event)event);
                    p_155017_.f_58319_ = event.getTotalCookTime();
                }
                ++p_155017_.f_58318_;
                if (p_155017_.f_58318_ == p_155017_.f_58319_) {
                    p_155017_.f_58318_ = 0;
                    p_155017_.f_58319_ = AbstractFurnaceBlockEntity.m_155009_(p_155014_, p_155017_.f_58312_, p_155017_);
                    if (p_155017_.burn(p_155017_.f_58857_, p_155017_.f_58858_, recipe, p_155017_.f_58310_, i)) {
                        p_155017_.m_6029_(recipe);
                    }
                    flag1 = true;
                }
            } else {
                p_155017_.f_58318_ = 0;
            }
        } else if (!p_155017_.m_58425_() && p_155017_.f_58318_ > 0) {
            p_155017_.f_58318_ = Mth.m_14045_((int)(p_155017_.f_58318_ - 2), (int)0, (int)p_155017_.f_58319_);
        }
        if (flag != p_155017_.m_58425_()) {
            flag1 = true;
            p_155016_ = (BlockState)((Object)p_155016_.m_61124_((Property)AbstractFurnaceBlock.f_48684_, Boolean.valueOf(p_155017_.m_58425_())));
            p_155014_.m_7731_(p_155015_, p_155016_, 3);
        }
        if (flag1) {
            AbstractFurnaceBlockEntity.m_155232_(p_155014_, p_155015_, p_155016_);
        }
    }

    private boolean m_155005_(@Nullable Recipe<?> p_155006_, NonNullList<net.minecraft.world.item.ItemStack> p_155007_, int p_155008_) {
        if (!((net.minecraft.world.item.ItemStack)((Object)p_155007_.get(0))).m_41619_() && p_155006_ != null) {
            net.minecraft.world.item.ItemStack itemstack = p_155006_.m_5874_(this);
            if (itemstack.m_41619_()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = (net.minecraft.world.item.ItemStack)((Object)p_155007_.get(2));
            if (itemstack1.m_41619_()) {
                return true;
            }
            if (!itemstack1.m_41656_(itemstack)) {
                return false;
            }
            if (itemstack1.m_41613_() + itemstack.m_41613_() <= p_155008_ && itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack1.m_41741_()) {
                return true;
            }
            return itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
        }
        return false;
    }

    private boolean m_155026_(@Nullable Recipe<?> p_155027_, NonNullList<net.minecraft.world.item.ItemStack> p_155028_, int p_155029_) {
        Level level = this.burn_level;
        BlockPos blockposition = this.burn_pos;
        this.burn_level = null;
        this.burn_pos = null;
        if (p_155027_ != null && this.m_155005_(p_155027_, p_155028_, p_155029_)) {
            net.minecraft.world.item.ItemStack itemstack = (net.minecraft.world.item.ItemStack)((Object)p_155028_.get(0));
            net.minecraft.world.item.ItemStack itemstack1 = p_155027_.m_5874_(this);
            net.minecraft.world.item.ItemStack itemstack2 = (net.minecraft.world.item.ItemStack)((Object)p_155028_.get(2));
            CraftItemStack source = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemstack1);
            if (level != null && blockposition != null) {
                FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent((Block)CraftBlock.at((LevelAccessor)level, (BlockPos)blockposition), (ItemStack)source, result);
                level.getCraftServer().getPluginManager().callEvent((Event)furnaceSmeltEvent);
                if (furnaceSmeltEvent.isCancelled()) {
                    return false;
                }
                result = furnaceSmeltEvent.getResult();
            }
            if (!(itemstack1 = CraftItemStack.asNMSCopy((ItemStack)result)).m_41619_()) {
                if (itemstack2.m_41619_()) {
                    p_155028_.set(2, (Object)itemstack1.m_41777_());
                } else if (CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack2).isSimilar(result)) {
                    itemstack2.m_41769_(itemstack1.m_41613_());
                } else {
                    return false;
                }
            }
            if (itemstack.m_150930_(Blocks.f_50057_.m_5456_()) && !((net.minecraft.world.item.ItemStack)((Object)p_155028_.get(1))).m_41619_() && ((net.minecraft.world.item.ItemStack)((Object)p_155028_.get(1))).m_150930_(Items.f_42446_)) {
                p_155028_.set(1, (Object)new net.minecraft.world.item.ItemStack(Items.f_42447_));
            }
            itemstack.m_41774_(1);
            return true;
        }
        return false;
    }

    private boolean burn(Level level, BlockPos blockposition, @Nullable Recipe<?> p_155027_, NonNullList<net.minecraft.world.item.ItemStack> p_155028_, int p_155029_) {
        this.burn_level = level;
        this.burn_pos = blockposition;
        return this.m_155026_(p_155027_, p_155028_, p_155029_);
    }

    protected int m_7743_(net.minecraft.world.item.ItemStack p_58343_) {
        if (p_58343_.m_41619_()) {
            return 0;
        }
        Item item = p_58343_.m_41720_();
        return ForgeHooks.getBurnTime((net.minecraft.world.item.ItemStack)p_58343_, this.f_58312_);
    }

    private static int m_155009_(Level p_155010_, RecipeType<? extends AbstractCookingRecipe> p_155011_, Container p_155012_) {
        return p_155010_ != null ? p_155010_.m_7465_().m_44015_(p_155011_, p_155012_, p_155010_).map(AbstractCookingRecipe::m_43753_).orElse(200) : 200;
    }

    public static boolean m_58399_(net.minecraft.world.item.ItemStack p_58400_) {
        return ForgeHooks.getBurnTime((net.minecraft.world.item.ItemStack)p_58400_, null) > 0;
    }

    public int[] m_7071_(Direction p_58363_) {
        if (p_58363_ == Direction.DOWN) {
            return f_58314_;
        }
        return p_58363_ == Direction.UP ? f_58313_ : f_58315_;
    }

    public boolean m_7155_(int p_58336_, net.minecraft.world.item.ItemStack p_58337_, @Nullable Direction p_58338_) {
        return this.m_7013_(p_58336_, p_58337_);
    }

    public boolean m_7157_(int p_58392_, net.minecraft.world.item.ItemStack p_58393_, Direction p_58394_) {
        if (p_58394_ == Direction.DOWN && p_58392_ == 1) {
            return p_58393_.m_150930_(Items.f_42447_) || p_58393_.m_150930_(Items.f_42446_);
        }
        return true;
    }

    @Override
    public int m_6643_() {
        return this.f_58310_.size();
    }

    @Override
    public boolean m_7983_() {
        for (net.minecraft.world.item.ItemStack itemstack : this.f_58310_) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public net.minecraft.world.item.ItemStack m_8020_(int p_58328_) {
        return (net.minecraft.world.item.ItemStack)((Object)this.f_58310_.get(p_58328_));
    }

    @Override
    public net.minecraft.world.item.ItemStack m_7407_(int p_58330_, int p_58331_) {
        return ContainerHelper.m_18969_(this.f_58310_, (int)p_58330_, (int)p_58331_);
    }

    @Override
    public net.minecraft.world.item.ItemStack m_8016_(int p_58387_) {
        return ContainerHelper.m_18966_(this.f_58310_, (int)p_58387_);
    }

    @Override
    public void m_6836_(int p_58333_, net.minecraft.world.item.ItemStack p_58334_) {
        net.minecraft.world.item.ItemStack itemstack = (net.minecraft.world.item.ItemStack)((Object)this.f_58310_.get(p_58333_));
        boolean flag = !p_58334_.m_41619_() && p_58334_.m_41656_(itemstack) && net.minecraft.world.item.ItemStack.m_41658_(p_58334_, itemstack);
        this.f_58310_.set(p_58333_, (Object)p_58334_);
        if (p_58334_.m_41613_() > this.m_6893_()) {
            p_58334_.m_41764_(this.m_6893_());
        }
        if (p_58333_ == 0 && !flag) {
            this.f_58319_ = AbstractFurnaceBlockEntity.m_155009_(this.f_58857_, this.f_58312_, this);
            this.f_58318_ = 0;
            this.m_6596_();
        }
    }

    @Override
    public boolean m_6542_(Player p_58340_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return p_58340_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public boolean m_7013_(int p_58389_, net.minecraft.world.item.ItemStack p_58390_) {
        if (p_58389_ == 2) {
            return false;
        }
        if (p_58389_ != 1) {
            return true;
        }
        net.minecraft.world.item.ItemStack itemstack = (net.minecraft.world.item.ItemStack)((Object)this.f_58310_.get(1));
        return ForgeHooks.getBurnTime((net.minecraft.world.item.ItemStack)p_58390_, this.f_58312_) > 0 || p_58390_.m_150930_(Items.f_42446_) && !itemstack.m_150930_(Items.f_42446_);
    }

    public void m_6211_() {
        this.f_58310_.clear();
    }

    public void m_6029_(@Nullable Recipe<?> p_58345_) {
        if (p_58345_ != null) {
            ResourceLocation resourcelocation = p_58345_.m_6423_();
            this.f_58320_.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_8015_(Player p_58396_) {
    }

    public void m_155003_(ServerPlayer p_155004_) {
        List<Recipe<?>> list = this.m_154995_(p_155004_.m_183503_(), p_155004_.m_20182_());
        p_155004_.m_7281_(list);
        this.f_58320_.clear();
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer p_155004_, net.minecraft.world.item.ItemStack itemstack, int amount) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(p_155004_.m_183503_(), p_155004_.m_20182_(), this.f_58858_, p_155004_, itemstack, amount);
        p_155004_.m_7281_(list);
        this.f_58320_.clear();
    }

    public List<Recipe<?>> m_154995_(ServerLevel p_154996_, Vec3 p_154997_) {
        return this.getRecipesToAwardAndPopExperience(p_154996_, p_154997_, this.f_58858_, null, null, 0);
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel p_154996_, Vec3 p_154997_, BlockPos blockposition, ServerPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.f_58320_.object2IntEntrySet()) {
            p_154996_.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(p_155023_ -> {
                list.add(p_155023_);
                AbstractFurnaceBlockEntity.createExperience(p_154996_, p_154997_, entry.getIntValue(), ((AbstractCookingRecipe)p_155023_).m_43750_(), blockposition, entityplayer, itemstack, amount);
            });
        }
        return list;
    }

    private static void m_154998_(ServerLevel p_154999_, Vec3 p_155000_, int p_155001_, float p_155002_) {
        int i = Mth.m_14143_((float)((float)p_155001_ * p_155002_));
        float f = Mth.m_14187_((float)((float)p_155001_ * p_155002_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        Object event = createExperience_amount != 0 ? new FurnaceExtractEvent((org.bukkit.entity.Player)createExperience_entityhuman.getBukkitEntity(), (Block)CraftBlock.at((LevelAccessor)p_154999_, (BlockPos)createExperience_blockposition), CraftMagicNumbers.getMaterial((Item)createExperience_itemstack.m_41720_()), createExperience_amount, i) : new BlockExpEvent((Block)CraftBlock.at((LevelAccessor)p_154999_, (BlockPos)createExperience_blockposition), i);
        p_154999_.getCraftServer().getPluginManager().callEvent((Event)event);
        i = event.getExpToDrop();
        ExperienceOrb.m_147082_(p_154999_, p_155000_, i);
    }

    private static void createExperience(ServerLevel p_154999_, Vec3 p_155000_, int p_155001_, float p_155002_, BlockPos blockposition, Player entityhuman, net.minecraft.world.item.ItemStack itemstack, int amount) {
        createExperience_blockposition = blockposition;
        createExperience_entityhuman = entityhuman;
        createExperience_itemstack = itemstack;
        createExperience_amount = amount;
        AbstractFurnaceBlockEntity.m_154998_(p_154999_, p_155000_, p_155001_, p_155002_);
    }

    public void m_5809_(StackedContents p_58342_) {
        for (net.minecraft.world.item.ItemStack itemstack : this.f_58310_) {
            p_58342_.m_36491_(itemstack);
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    @Override
    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.f_58310_;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add((HumanEntity)who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int m_6893_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public Object2IntOpenHashMap<ResourceLocation> getRecipesUsed() {
        return this.f_58320_;
    }
}

